USE [Elerium]
GO

/****** Object:  Table [dbo].[RewardProject]    Script Date: 10/23/2013 1:02:10 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[RewardProject](
	[ID] [int] NOT NULL,
	[ProjectID] [int] NULL,
	[RewardLegacyProjectID] [int] NULL,
	[DatePopularityModified] [datetime] NULL,
	[IsBlacklisted] [bit] NOT NULL,
	[PopularityScore] [decimal](19, 9) NOT NULL,
 CONSTRAINT [PK_RewardProject] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[RewardProject] ADD  CONSTRAINT [DF_RewardProject_IsBlacklisted]  DEFAULT ((0)) FOR [IsBlacklisted]
GO

ALTER TABLE [dbo].[RewardProject] ADD  CONSTRAINT [DF_RewardProject_PopularityScore]  DEFAULT ((0)) FOR [PopularityScore]
GO

ALTER TABLE [dbo].[RewardProject]  WITH CHECK ADD  CONSTRAINT [FK_RewardProject_Project] FOREIGN KEY([ProjectID])
REFERENCES [dbo].[Project] ([ID])
GO

ALTER TABLE [dbo].[RewardProject] CHECK CONSTRAINT [FK_RewardProject_Project]
GO

ALTER TABLE [dbo].[RewardProject]  WITH CHECK ADD  CONSTRAINT [FK_RewardProject_RewardLegacyProject] FOREIGN KEY([RewardLegacyProjectID])
REFERENCES [dbo].[RewardLegacyProject] ([ID])
GO

ALTER TABLE [dbo].[RewardProject] CHECK CONSTRAINT [FK_RewardProject_RewardLegacyProject]
GO

ALTER TABLE [dbo].[RewardProject]  WITH CHECK ADD  CONSTRAINT [CK_RewardProject_EnsureIntegrity] CHECK  (([ProjectID]=[ID] AND [RewardLegacyProjectID] IS NULL OR [RewardLegacyProjectID]=[ID] AND [ProjectID] IS NULL))
GO

ALTER TABLE [dbo].[RewardProject] CHECK CONSTRAINT [CK_RewardProject_EnsureIntegrity]
GO


